include <../doblo-factory.scad>;
include <../lib/doblo-params.scad>;

SCALE = 0.5;

// WARNING === DO NOT USE, this is legacy stuff that must be digested

// ---------------------- Ready made modules for testing--------------------------
// Below are a few modules ready for printing. The modules are defined further down
// COMMENT/UNCOMMENT - You need ONE of these or add your own

// --- a standard brick
// test (); // random tests
// doblo_brick ();
// doblo_board ();

// ----- end user interface for doing mashups
merge_brick (); 

// ----- Demoes all the different kind of bricks
// exhibit (); 
// 
// ----- Next modules create larger "unioned" structures

// stronghold ();
// stairs_world ();
// stairs_world_light ();

// -----  Testing for some kinds of weird bricks
// letter_world ();
// merge_test1_cyls ();
// merge_test1_support ();

/*

// --------------------------------------------------------------------------------
// -------------------- EXAMPLE MODULES   -----------------------------------------

// -------- latest stuff for testing 

module test ()
{
   pillar_lr ();
    //    (col, row, up, width,length,height,       nibbles_on_off) 
    doblo (0,   0,   0,   2,   2,     4,  true);
}

// -------- a standard brick

module doblo_brick ()
{
    //    (col, row, up, width,length,height,nibbles_on_off) 
    // doblo   (0,   0,   0,   4,   2,     3,   false);
    // nibbles (0,   0,   3,   2,   2);
    //   doblo (0,   0,   0,   2,   2,     3,    true);
     doblo (0,   0,   0,   2,   2,     3,    false);
    // doblo (-1,   -1,   0,   4,   4,     4,    true);
}


// ------ simple board

module doblo_board () {
     //    (col, row, up, width,length,height,nibbles_on_off) 
     doblo   (0,   0,   0,   10,  12,  THIRD,   false, false, LUGO);
     //     (col, row, up, width, length)
     nibbles (0,   0,   THIRD,   1,   11, LUGO);
     nibbles (3,   0,   THIRD,   1,   11, LUGO);
     nibbles (6,   0,   THIRD,   1,   11, LUGO);
     nibbles (9,   0,   THIRD,   1,   11, LUGO);
     nibbles (1,   0,   THIRD,   9,   1, LUGO);
     nibbles (0,  11,   THIRD,   10,  1, LUGO);
}

// ----- exhibit
// not really for printing, displays all (most?) bricks.

module exhibit ()
{
    union () {

	// duplo compatible brick with nibbles
	//    (col, row, up, width,length,height,nibbles_on_off) 
	doblo (-9,  -4,   0,  2,   4,    4,    true);

	// cylinder
        //          (col, row, up, bottom_r, top_r, height, nibbles_on_off) 
	cyl_block   (-4,   -4,   0,  2,       5,     8,   true) ;

	// support blocks and block with nibbles on top
	//          (col,row,up,height,angle)
	support     (0,   -4,   0,   10,   0, 1) ;
	support     (4,   -4,   0,   10,   180, 1) ;
        //          (col, row, up, width,length,height,nibbles_on_off) 
	block       (0,   -4,   10,  5,    1,     1,     true);


	// building blocks with and without nibbles
        //          (col, row, up, width,length,height,nibbles_on_off) 
	block       (6,  -4,   0,  3,    3,     3,     false);
	block       (6,  -4,   3,  2,    2,     3,     true);
	block       (8,  -4,   3,  1,    3,     8,     false);

	// Just nibbles
	//             (col, row, up, width, length)
	nibbles        (1,   1,   0,  2,     2      );
	//             (col, row, up, width, length, up)
	bottom_nibbles (-2,  1,   0,  1,     1,   3);

	// duplo compatible brick without nibbles and some stl on top
	//    (col, row, up, width,length,height,nibbles_on_off) 
	doblo (6,  1,   0,  2,   2,    2,    false);
	//        (stl_file,                  col, row, height, stl_lift);
	merge_stl ("woman-MULHER_2_small.stl", 6,  1,   1,      5);
	// postion in between the usual grid to match the head. also use two
	//             (col, row, up, width, length)
	nibbles        (7,  1.3,    15.5,    1,   1      );
	nibbles        (7,  1.3,    16.5,    1,   1      );

	// ramp
	ramp  (-5,  6,   0,  5,   180);
	
	// glyph on a 2x2 doblo
	//           (col, row, up, width,length,height,nibbles_on_off) 
	doblo        (-2,   6,   0,   2,   2,     2,    false); 
	//           (col, row, up, height_mm, char)
	glyph        (-2,   6,   2,  4,       "A");

	// text on a 2x12 doblo
	//           (col, row, up, width,length,height,nibbles_on_off) 
	block        (1,   6,   0,   12,   4,     2,    false); 
	//           (col, row, up, height_mm, chars, char_count)
	text         (1,   6,   2,  4,       ["T","H","i","N","G","Y"], 6);
	text         (1,   8,   2,  4,       ["V","E","R","S","E"], 5);

    }
}

// ------ weird simple bricks - for test each


module letter_world () {
    //           (col, row, up, width,length,height,nibbles_on_off) 
    doblo        (-2,   -2,   0,   2,   2,     2,    false); 
    //           (col, row, up, height_mm, char)
    glyph        (-2,   -2, 2,  3,       "A");

    block        (1,   6,   0,   12,   4,     2,    false); 
    text         (1,   6,   2,  4,       ["T","H","i","N","G","Y"], 6);
    text         (1,   8,   2,  4,       ["V","E","R","S","E"], 5);
}

// ------------------- A stronghold

module stronghold ()
{
    union()
	{
	    //    Base plate, for faster printing replace by block
	    //    (col, row, up, width,length,height,nibbles_on_off) 
	    // doblo (-5,  -5,   0,  10,   10,    1,     false);
	    doblo_light (-6,  -6,   0,  12,   12,    1,     false);

	    //      (col, row, up, width, length)
	    nibbles (3,   -6,   1,  3,     3      );
	    nibbles (1,   3,   1,  5,     3      );
	    nibbles (-6,  3,   1,  3,     3      );
            //    (col, row, up, width,length,height,nibbles_on_off) - blocks
            //    (col, row, up, height,degrees) - ramps    
	    // back

	    ramp  (-5,  -5,   1,  2,   0);
	    block (-5,  -5,   1,  1,   1,    12,     false);	    

	    ramp  (-3,  -5,   1,  2,   0);
	    ramp  (-3,  -5,   1,  2,   180);
	    block (-3,  -5,   1,  1,   1,    12,     false);	    

	    ramp  (-1,  -5,   1,  2,   0);
	    ramp  (-1,  -5,   1,  2,   180);
	    block (-1,  -5,   1,  1,   1,    12,     false);	    

	    ramp  (1,  -5,   1,  2,   180);
	    block (1,  -5,   1,  1,   1,    12,     false);	    
	    // left
	    block (-5,  -3,   1,  1,   1,    22,     false);
	    block (-5,  -1,   1,  1,   1,    22,     false);
	    // front
	    ramp  (-5,  1,   1,  2,   0);
	    block (-5,  1,   1,  1,   1,    12,     false);	    

	    ramp  (-3,  1,   1,  2,   0);
	    ramp  (-3,  1,   1,  2,   180);
	    block (-3,  1,   1,  1,   1,    12,     false);	    

	    ramp  (-1,  1,   1,  2,   0);
	    ramp  (-1,  1,   1,  2,   180);
	    block (-1,  1,   1,  1,   1,    12,     false);	    

	    ramp  (1,  1,   1,  2,   180);
	    block (1,  1,   1,  1,   1,    12,     false);	    
	    // right
	    // block (0,  -4,   1,  1,   3,    8,     false);
	    // big arc
            //      (col, row, up, height,degrees) 
	    support (-5, -5,   9,   14,   270, 1) ;
	    support (-4.1,  -5,  21,  2.2,  0, 7);
	    support (-3.9,  -5,  21,  2.2,   180, 7);

	    support (-3, -5,   9,   14,   270, 1) ;
	    support (-2.1,  -5,  21,  2.2,  0, 7);
	    support (-1.9,  -5,  21,  2.2,   180, 7);

	    support (-1, -5,   9,   14,   270, 1) ;
	    support (-0.1,  -5,  21,  2.2,  0, 7);
	    support (0.1,  -5,  21,  2.2,   180, 7);

	    support (1,  -5,   9,   14,   270, 1) ;
	    
	    support (-5, 1,   9,   14,   90, 1) ;

	    support (-3, 1,   9,   14,   90, 1) ;

	    support (-1, 1,   9,   14,   90, 1) ;

	    support (1,  1,   9,   14,   90, 1) ;
	    
	    // Roof
            //    (col, row, up, width,length,height,nibbles_on_off) 
	    block   (-5,  -5,   23,  7,   7,    1,     false);
	    nibbles (-3,  -3,   24,  3,   3);

	    block (-5,  -5,   24,  7,   1,    4,     false);
	    nibbles (-4,  -5,   28,  5,   1);

	    block (-5,  1,   24,  7,   1,    4,     false);
	    nibbles (-5,  -4,   28,  1,   5);

	    block (-5,  -4,   24,  1,   5,    4,     false);
	    nibbles (-4,  1,   28,  5,   1);

	    block (1,  -4,   24,  1,   5,    4,     false);
	    nibbles (1,  -4,   28,  1,   5);
	    //          (col, row, up, bottom_r, top_r, height, nibbles_on_off) 
	    cyl_block   (-6,   -6,  1,  2,       2,     32,   true) ;
	    cyl_block   (1,   -6,  1,  2,       2,     32,   true) ;
	    cyl_block   (-6,   1,  1,  2,       2,     32,   true) ;
	    cyl_block   (1,   1,  1,  2,       2,     32,   true) ;
	}
}
    


// ------- some cylinders 

module merge_test1_cyls ()
{
    union()
	{
	    //      (col, row, up, bottom_r, top_r, height, nibbles_on_off) 
	    cyl_block (-2,  2,    2,  2,       2,     2,      true) ;
	    //      (col, row, up, width,length,height,nibbles_on_off) 
	    block   (-2,  2,    0,  2,    2,     2,     false);
	    
	    //      (col, row, up, bottom_r, top_r, height, nibbles_on_off) 
	    cyl_block (2,  -2,    12,  1,       5,     4,      true) ;
	    //      (col, row, up, width,length,height,nibbles_on_off) 
	    block   (2,  -2,    0,  1,    1,     12,     false);
	    
	    //      (col, row, up, bottom_r, top_r, height, nibbles_on_off) 
	    cyl_block (2,  2,    5,  1,       4,     6,      true) ;
	    //      (col, row, up, width,length,height,nibbles_on_off) 
	    block   (2,  2,    0,  1,    1,     6,     false);
	    // nibbles (2,  2,   14,  3,     3      );
	    
	    //      control
	    cyl_block (-1,  -1,  0,  1,       2,     4,      true) ;
	}
}

// ---------- merging STL test

module merge_test1_support () {
    // doblo (-6,  3,   0,  18,   1,    1,     true);

    //  (col,row,up,height,angle, thickness)
support (-3,  0,  0, 24,    180, 3);
//      (col, row, up, width,length,height,nibbles_on_off) 
block   (-3,  0, -1,  1,1,1,     false);

support (-1,  0,  0,  16, 90, 1);
block   (-1,  0, -1,  1,  1,  1,     false);

support (3,  0,  0,  12,90, 2);
block   (3,  0, -1,  1,1,1,     false);

support (6,  0,  0,  8,0, 3);
block   (6,  0, -1,  1,1,1,     false);

support (9,  0,  0,  4,270, 3);
block   (9,  0, -1,  1,1,1,     false);
}

// ---- END testing modules
